function ret = isSimilar(new_frame, golden_frame, threshold, table_pos)
% this function checks the similarity of the input images in terms of the
% accumulated pixel-wise differences and compares it to the threshold

x1 = table_pos(1,2)+1;
y1 = table_pos(1,1)+1;
x2 = table_pos(2,2)+1;
y2 = table_pos(2,1)+1;


golden_frame = rgb2ycbcr(golden_frame);
new_frame = rgb2ycbcr(new_frame);

im1 = golden_frame(x1:x2, y1:y2, 2:3);
im2 = new_frame (x1:x2, y1:y2, 2:3);

% figure(1); subplot(2,2,1);
% imshow(im1);
% figure(1); subplot(2,2,2);
% imshow(im2);

diff = abs(im2-im1);
ssum = sum(sum(sum(diff)));
ret = 0;
if (  ssum < threshold) 
    ret = 1; 
end;

return;